﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Car_List
{
    struct Automobile
    {
        public string make;
        public int year;
        public double mileage;
    }

    public partial class Form1 : Form
    {
        // Utworzenie obiektu List jako pola.
        private List<Automobile> carList = new List<Automobile>();

        public Form1()
        {
            InitializeComponent();
        }

        // Metoda GetData() pobiera dane wprowadzone
        // przez użytkownika i przypisuje je polom
        // parameteru obiektu.
        private void GetData(ref Automobile auto)
        {
            try
            {
                // Pobranie danych z kontrolek TextBoxe.
                auto.make = makeTextBox.Text;
                auto.year = int.Parse(yearTextBox.Text);
                auto.mileage = double.Parse(mileageTextBox.Text);
            }
            catch (Exception ex)
            {
                // Wyświetlenie komunikatu wygenerowanego przez wyjątek.
                MessageBox.Show(ex.Message);
            }
        }

        private void addButton_Click(object sender, EventArgs e)
        {
            // Utworzenie egzemplarza struktury Automobile.
            Automobile car = new Automobile();

            // Pobranie danych wprowadzonych przez użytkownika.
            GetData(ref car);

            // Dodanie obiektu car do kontenera List.
            carList.Add(car);

            // Usunięcie zawrtości kontrolek TextBoxe.
            makeTextBox.Clear();
            yearTextBox.Clear();
            mileageTextBox.Clear();

            // Uaktywnienie kontrolki makeTextBox.
            makeTextBox.Focus();
        }

        private void displayButton_Click(object sender, EventArgs e)
        {
            // Zadeklarowanie ciągu tekstowego przechowującego wiersz danych wyjściowych.
            string output;

            // Usunięcie aktualnej zawartości kontrolki ListBox.
            carListBox.Items.Clear();

            // Wyświetlenie w kontrolce ListBox informacji o samochodzie.
            foreach (Automobile aCar in carList)
            {
                // Wygenerowanie wiersza danych wyjściowych.
                output = aCar.make + " z roku " + aCar.year +
                    " o przebiegu " + aCar.mileage + " km.";

                // Dodanie do kontrolki ListBox wiersza danych wyjściowych.
                carListBox.Items.Add(output);
            }
        }
    }
}
